clear all, close all

% general directory
folder = 'D:\Profiles\BennekerAM\Dropbox\Desalination\Figures for the manuscript\Data for IV-plots\Chronoamperometry\Measurements 1\Chip14_1mMNaCl_5uMAlexa_3uLmin_70V_samples5';

[U,I,t] = read_data_keithley(folder,0);

% plot figure
nn = 0;

% plot values on log-lin scale
nn = nn+1;
figure(nn)
hold on
plot(t,1e6.*I,'-')
hold off
box on
xlabel('t (s)')
ylabel('I (\muA)')
title('(a) 1 mM NaCl, 3 \muL/min, \DeltaU = 70V')

% calculation of total ion transport
t_start = 500;
t_end = 1500;
I_avg = mean(I(t_start:t_end));
elem_charge = 1.602e-19;
transp_ions_per_second = I_avg/elem_charge;
N_A = 6.02214086e23;
C_in = 1e-3;
V_in = 3e-6/60;
inlet_ions_per_second = N_A*C_in*2*V_in;

expect_sep = transp_ions_per_second/inlet_ions_per_second;


